<?php
 include('dbcon.php');
//get records from database
$query = $con->query("SELECT * from property_events ORDER BY id DESC");

if($query->num_rows > 0){
    $delimiter = ",";
    $filename = "Events_" . date('Y-m-d') . ".csv";
    
    //create a file pointer
    $f = fopen('php://memory', 'w');
    
    //set column headers
    $fields = array('Id', 'Event Type','Event Title', 'Orgnizer','About Event','Start Date & Time','End Date & Time', 'Venue', 'Media Partner', 'Sponsers', 'Food beverages','Available Seat','Buyer Seats','Seller seats', 'Ticket Fee ');
    fputcsv($f, $fields, $delimiter);
    
    //output each row of the data, format line as csv and write to file pointer
    while($row = $query->fetch_assoc()){
       
        $lineData = array($row['id'], $row['event_type'], $row['event_title'], $row['orgnizer'],$row['about_event'], $row['date_time'],$row['end_date'], $row['venue'], $row['media_partner'], $row['sponsers'], $row['food_beverages'], $row['available_seats'],$row['buyer_seat'],$row['seller_img'], $row['ticket_fee']);
        fputcsv($f, $lineData, $delimiter);
    }
    
    //move back to beginning of file
    fseek($f, 0);
    
    //set headers to download file rather than displayed
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="' . $filename . '";');
    
    //output all remaining data on a file pointer
    fpassthru($f);
}

exit;
?>
