<?php
 include('dbcon.php');
//get records from database
$query = $con->query("SELECT * from property_news");

if($query->num_rows > 0){
    $delimiter = ",";
    $filename = "News_" . date('Y-m-d') . ".csv";
    
    //create a file pointer
    $f = fopen('php://memory', 'w');
    
    //set column headers
    $fields = array('Id', 'Heading','Description','Youtube Link');
    fputcsv($f, $fields, $delimiter);
    
    //output each row of the data, format line as csv and write to file pointer
    while($row = $query->fetch_assoc()){
       
        $lineData = array($row['id'], $row['heading'], $row['description'], $row['youtube_link']);
        fputcsv($f, $lineData, $delimiter);
    }
    
    //move back to beginning of file
    fseek($f, 0);
    
    //set headers to download file rather than displayed
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="' . $filename . '";');
    
    //output all remaining data on a file pointer
    fpassthru($f);
}

exit;
?>
